<?php
/*************************************************************************************/
/* registering banks post type.* /
/**************************************************************************************/
add_action( 'init', 'create_post_types_banks' );

function create_post_types_banks() {
    register_post_type( 'banks', array(
            'labels'              => array(
                'name'               => __( 'الحسابات البنكية', 'm7md' ),
                'singular_name'      => __( 'الحسابات البنكية', 'm7md' ),
                'add_new'            => __( 'إضافة حساب', 'm7md' ),
                'add_new_item'       => __( 'حساب جديد', 'm7md' ),
                'all_items'          => __( 'الحسابات البنكية', 'm7md' ),
                'edit_item'          => __( 'تحرير حساب', 'm7md' ),
                'new_item'           => __( 'حساب جديد', 'm7md' ),
                'view_item'          => __( 'معاينة حساب', 'm7md' ),
                'search_items'       => __( 'البحث عن حساب', 'm7md' ),
                'not_found'          => __( 'لا يوجد حساب', 'm7md' ),
                'not_found_in_trash' => __( 'لا يوجد حساب', 'm7md' ),
                'parent_item_colon'  => ''
            ),
            'menu_icon'           => 'dashicons-admin-generic',
            'hierarchical'        => true,
            'public'              => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'menu_position'       => 6,
            'supports'            => array(
              //  'thumbnail',
                'title',
              //  'editor',
               // 'tags'
            ),
            'query_var'           => true,
            'rewrite'             => array( 'slug' => 'banks' ),
        )
    );
}



// hook into the init action and call create_banks_taxonomies when it fires
//add_action( 'init', 'create_banks_taxonomies', 0 );
// create two taxonomies, genres and writers for the post type "prints"
function create_banks_taxonomies() {
    // Add new taxonomy, make it hierarchical (like categories)
    $labels = array(
        'name'              => __( 'أقسام الحسابات البنكية', 'm7md' ),
        'all_items'         => __( 'كافة الأقسام', 'm7md' ),
    );

    $args = array(
        'hierarchical'        => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'bank' ),
    );

    register_taxonomy( 'banks_taxonomy', array( 'banks' ), $args );
}
